/*
 * Decompiled with CFR 0.152.
 */
package pl.amon.moretinygates.blocks;

import com.dannyandson.tinygates.blocks.AbstractGateBlockEntity;
import com.dannyandson.tinygates.blocks.Side;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import pl.amon.moretinygates.gates.Generator;
import pl.amon.moretinygates.setup.Registration;

public class GeneratorBlockEntity
extends AbstractGateBlockEntity {
    boolean powerOn = true;
    int level = 0;

    public GeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.GENERATOR_BLOCK_ENTITY.get(), pos, state);
    }

    public ResourceLocation getTexture() {
        if (this.powerOn) {
            return Generator.TEXTURE_ON[this.level];
        }
        return Generator.TEXTURE_OFF[this.level];
    }

    public boolean onNeighborChange(@Nullable BlockPos neighbor) {
        boolean powerOn;
        Direction backDirection = this.getDirectionFromSide(Side.BACK);
        int back = this.m_58904_().m_277185_(this.m_58899_().m_121945_(backDirection), backDirection);
        boolean bl = powerOn = back == 0;
        if (powerOn != this.powerOn) {
            this.powerOn = powerOn;
            this.output = this.powerOn ? this.level : 0;
            return true;
        }
        return false;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("powerOn", this.powerOn);
        nbt.m_128405_("level", this.level);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.powerOn = compoundTag.m_128471_("powerOn");
        this.level = compoundTag.m_128451_("level");
    }

    public void onActivated() {
        ++this.level;
        if (this.level >= 16) {
            this.level = 0;
        }
        if (this.powerOn) {
            this.output = this.level;
        }
        this.outputChange();
    }
}

